#include <Arduino.h>
#include "SoftwareSerial.h"

typedef enum {
    Start,
    Stop,
    ContinuousMode,
    VersionDate,
    None
} PmSensorCmd;

template<typename T, std::size_t N>
constexpr std::size_t array_num_elements(const T(&)[N]) {
    return N;
}

bool is_PMS_running = true;


EspSoftwareSerial::UART serialSDS;//(PM_SERIAL_RX, PM_SERIAL_TX, false);
static bool PMS_cmd(PmSensorCmd cmd) {
    static constexpr uint8_t start_cmd[] PROGMEM = {
            0x42, 0x4D, 0xE4, 0x00, 0x01, 0x01, 0x74
    };
    static constexpr uint8_t stop_cmd[] PROGMEM = {
            0x42, 0x4D, 0xE4, 0x00, 0x00, 0x01, 0x73
    };
    static constexpr uint8_t continuous_mode_cmd[] PROGMEM = {
            0x42, 0x4D, 0xE1, 0x00, 0x01, 0x01, 0x71
    };
    constexpr uint8_t cmd_len = array_num_elements(start_cmd);

    uint8_t buf[cmd_len];
    switch (cmd) {
        case PmSensorCmd::Start:
            memcpy_P(buf, start_cmd, cmd_len);
            break;
        case PmSensorCmd::Stop:
            memcpy_P(buf, stop_cmd, cmd_len);
            break;
        case PmSensorCmd::ContinuousMode:
            memcpy_P(buf, continuous_mode_cmd, cmd_len);
            break;
        case PmSensorCmd::VersionDate:
            assert(false && "not supported by this sensor");
            break;
    }
    serialSDS.write(buf, cmd_len);
    return cmd != PmSensorCmd::Stop;
}


void sensorPMS() {
    String s = "";
    char buffer;
    int value;
    int len = 0;
    int pm1_serial = 0;
    int pm10_serial = 0;
    int pm25_serial = 0;
    int pm03_count = 0;
    int pm05_count = 0;
    int pm1_count = 0;
    int pm5_count = 0;
    int pm10_count = 0;
    int pm25_count = 0;
    int checksum_is = 0;
    int checksum_should = 0;
    int checksum_ok = 0;
    int frame_len = 24;                // min. frame length
    int t = 0;
    int rh = 0;

    if (is_PMS_running) {
        is_PMS_running = PMS_cmd(PmSensorCmd::Stop);
    } else {
        is_PMS_running = PMS_cmd(PmSensorCmd::Start);
    }

    while (serialSDS.available() > 0) {
        buffer = serialSDS.read();
//        debug_out(String(len) + " - " + String(buffer, DEC) + " - " + String(buffer, HEX) + " - " + int(buffer) + " .",
//                  DEBUG_MAX_INFO, 1);
//			"aa" = 170, "ab" = 171, "c0" = 192
        value = int(buffer);
        switch (len) {
            case (0):
                if (value != 66) {
                    len = -1;
                };
                break;
            case (1):
                if (value != 77) {
                    len = -1;
                };
                break;
            case (2):
                checksum_is = value;
                break;
            case (3):
                frame_len = value + 4;
                break;
            case (10):
                pm1_serial += (value << 8);
                break;
            case (11):
                pm1_serial += value;
                break;
            case (12):
                pm25_serial = (value << 8);
                break;
            case (13):
                pm25_serial += value;
                break;
            case (14):
                pm10_serial = (value << 8);
                break;
            case (15):
                pm10_serial += value;
                break;
            case (16):
                pm03_count += (value << 8);
                break;
            case (17):
                pm03_count += value;
                break;
            case (18):
                pm05_count += (value << 8);
                break;
            case (19):
                pm05_count += value;
                break;
            case (20):
                pm1_count = (value << 8);
                break;
            case (21):
                pm1_count += value;
                break;
            case (22):
                pm25_count = (value << 8);
                break;
            case (23):
                pm25_count += value;
                break;
            case (24):
                pm5_count = (value << 8);
                break;
            case (25):
                pm5_count += value;
                break;
            case (26):
                pm10_count = (value << 8);
                break;
            case (27):
                pm10_count += value;
                break;
            case (28):
                t = (value << 8);
                break;
            case (29):
                t += value;
                break;
            case (30):
                rh = (value << 8);
                break;
            case (31):
                rh += value;
                break;
            case (32):
                checksum_should = (value << 8);
                break;
            case (33):
                checksum_should += value;
                break;
        }
        if ((len > 2) && (len < (frame_len - 2))) { checksum_is += value; }
        len++;
        if (len == frame_len) {
            Serial.print("CHecksum: ");
            Serial.println(checksum_is + 143);
            Serial.print("CHecksum should: ");
            Serial.println(checksum_should + 143);
            if (checksum_should == (checksum_is + 143)) {
                checksum_ok = 1;
            } else {
                len = 0;
            };
            if (checksum_ok == 1) {
                Serial.printf("PM1: %i\n", pm1_serial);
                Serial.printf("PM2.5: %i\n", pm25_serial);
                Serial.printf("PM10: %i\n", pm10_serial);
                Serial.printf("Cnt 0.3: %i\n", pm03_count);
                Serial.printf("Cnt 0.5: %i\n", pm05_count);
                Serial.printf("Cnt 1: %i\n", pm1_count);
                Serial.printf("Cnt 5: %i\n", pm5_count);
                Serial.printf("Cnt 10: %i\n", pm10_count);
                Serial.printf("Temp: %.2f\n", (t - 450) / 10.0);
                Serial.printf("RH: %.2f\n", rh/10.0);
                Serial.println("----------------\n");
            }
            len = 0;
            checksum_ok = 0;
            pm1_serial = 0.0;
            pm10_serial = 0.0;
            pm25_serial = 0.0;
            checksum_is = 0;
        }
    }
    yield();
}



#define PM_SERIAL_RX D1
#define PM_SERIAL_TX D2

void setup() {
// write your initialization code here
    Serial.begin(115200);
    serialSDS.begin(9600, SWSERIAL_8N1, PM_SERIAL_RX, PM_SERIAL_TX, false, 38);
    PMS_cmd(PmSensorCmd::Start);

}

void loop() {
// write your code here
    delay(100);
    sensorPMS();
}